//+---------------------------------------------------------------------+
//|                                                           JSatl.mq5 |
//|                                  Copyright  2016, Nikolay Kositsin |
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrDeepPink
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "JSATL"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price 
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iLength=5; //  JMA                    
input int iPhase=100; //  JMA ,
//----    -100 ... +100,
//----     ;
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int SATLShift=0; //      
input int PriceShift=0; // c     
//+----------------------------------------------+
//----         
int SATLPeriod=65;
//----   ,    
//      
double ExtLineBuffer[];
//----
int min_rates_total,fstart,SATLSize;
double dPriceShift;
//+------------------------------------------------------------------+
//   iPriceSeries()                                   |
//   iPriceSeriesAlert()                              |
//   CJJMA                                             |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//----    CJJMA   JJMASeries_Cls.mqh
CJJMA JMA; 
//----    CSATL   JJMASeries_Cls.mqh
CSATL STL; 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       SATLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,SATLShift);
//----   
   min_rates_total=SATLSize+30;
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   string shortname;
   StringConcatenate(shortname,"JSATL(",iLength," ,",iPhase,")");
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    
   dPriceShift=_Point*PriceShift;
//----       
   JMA.JJMALengthCheck("iLength", iLength);
   JMA.JJMAPhaseCheck("iPhase", iPhase);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total)return(0);

//----    
   int first,bar;
   double price,satl,jsatl;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=SATLPeriod-1; //      
      fstart=first;
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      satl=STL.SATLSeries(0,prev_calculated,rates_total,price,bar,false);
      jsatl=JMA.JJMASeries(fstart,prev_calculated,rates_total,0,iPhase,iLength,satl,bar,false);
      ExtLineBuffer[bar]=jsatl+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
