//+------------------------------------------------------------------+
//|                                                   Full-stats.mq4 |
//|                             Copyright 2024, Trade Smart FX Tools |
//|                                 https://tradesmartfxtools.online |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, Trade Smart FX Tools"
#property link      "https://tradesmartfxtools.online/"
#property version   "1.00"
#property strict

string labelName = "tradesmartfxtools.online";
string labelText = "EA by tradesmartfxtools.online";
string buyProfitLabelName = "OverallBuyProfitLabel";
string sellProfitLabelName = "OverallSellProfitLabel";
string buyCountLabelName = "BuyCountLabel";  
string sellCountLabelName = "SellCountLabel"; 
string spreadLabelName = "SpreadLabel";
string updatedLabelName = "updated_version_label"; 
string updatedLabelText = "Updated version available at tradesmartfxtools.online"; 
int labelFontSize = 14;
int updatedLabelFontSize = 12; // Font size for updated version text
color labelColor = Yellow;
color profitLabelColor = White;
color lossLabelColor = White;
color spreadLabelColor = White;
color updatedLabelColor = White; // Updated version label color
int spaceFromBottom = 50;
int updatedSpaceFromBottom = 20; // Position for updated version label

void createOrUpdateLabels(double buyProfit, double sellProfit, int buyCount, int sellCount, double spread)
  {
   // Create or update the trademark label (kept in the bottom-left corner)
   if(ObjectFind(0, labelName) == -1)
     {
      ObjectCreate(0, labelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, labelName, OBJPROP_CORNER, CORNER_LEFT_LOWER);
   ObjectSetInteger(0, labelName, OBJPROP_XDISTANCE, 10);
   ObjectSetInteger(0, labelName, OBJPROP_YDISTANCE, spaceFromBottom);
   ObjectSetInteger(0, labelName, OBJPROP_COLOR, labelColor);
   ObjectSetInteger(0, labelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, labelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, labelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, labelName, OBJPROP_TEXT, labelText);

   // Create or update the updated version label (kept below the trademark label)
   if(ObjectFind(0, updatedLabelName) == -1)
     {
      ObjectCreate(0, updatedLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, updatedLabelName, OBJPROP_CORNER, CORNER_LEFT_LOWER);
   ObjectSetInteger(0, updatedLabelName, OBJPROP_XDISTANCE, 10);
   ObjectSetInteger(0, updatedLabelName, OBJPROP_YDISTANCE, updatedSpaceFromBottom);
   ObjectSetInteger(0, updatedLabelName, OBJPROP_COLOR, updatedLabelColor);
   ObjectSetInteger(0, updatedLabelName, OBJPROP_FONTSIZE, updatedLabelFontSize);
   ObjectSetString(0, updatedLabelName, OBJPROP_TEXT, updatedLabelText);

   // Create or update the buy profit label (move to the upper-right corner)
   string buyProfitText = "Overall Buy Profit: " + DoubleToString(buyProfit, 2);
   if(ObjectFind(0, buyProfitLabelName) == -1)
     {
      ObjectCreate(0, buyProfitLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_XDISTANCE, 270);
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_YDISTANCE, spaceFromBottom - 6); // Adjusted Y position
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_COLOR, profitLabelColor);
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, buyProfitLabelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, buyProfitLabelName, OBJPROP_TEXT, buyProfitText);

   // Create or update the sell profit label (move to the upper-right corner)
   string sellProfitText = "Overall Sell Profit: " + DoubleToString(sellProfit, 2);
   if(ObjectFind(0, sellProfitLabelName) == -1)
     {
      ObjectCreate(0, sellProfitLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_XDISTANCE, 270);
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_YDISTANCE, spaceFromBottom - 36); // Adjusted Y position
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_COLOR, lossLabelColor);
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, sellProfitLabelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, sellProfitLabelName, OBJPROP_TEXT, sellProfitText);

   // Create or update the buy count label (move to the upper-right corner)
   string buyCountText = "Current Buy Trades: " + IntegerToString(buyCount);
   if(ObjectFind(0, buyCountLabelName) == -1)
     {
      ObjectCreate(0, buyCountLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_XDISTANCE, 270);
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_YDISTANCE, spaceFromBottom + 26); // Adjusted Y position
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_COLOR, profitLabelColor);
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, buyCountLabelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, buyCountLabelName, OBJPROP_TEXT, buyCountText);

   // Create or update the sell count label (move to the upper-right corner)
   string sellCountText = "Current Sell Trades: " + IntegerToString(sellCount);
   if(ObjectFind(0, sellCountLabelName) == -1)
     {
      ObjectCreate(0, sellCountLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_XDISTANCE, 270);
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_YDISTANCE, spaceFromBottom + 56); // Adjusted Y position
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_COLOR, lossLabelColor);
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, sellCountLabelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, sellCountLabelName, OBJPROP_TEXT, sellCountText);

   // Create or update the spread label (move to the upper-right corner)
   string spreadText = "Current Spread: " + DoubleToString(spread, 1);
   if(ObjectFind(0, spreadLabelName) == -1)
     {
      ObjectCreate(0, spreadLabelName, OBJ_LABEL, 0, 0, 0);
     }
   ObjectSetInteger(0, spreadLabelName, OBJPROP_CORNER, CORNER_RIGHT_UPPER);
   ObjectSetInteger(0, spreadLabelName, OBJPROP_XDISTANCE, 270);
   ObjectSetInteger(0, spreadLabelName, OBJPROP_YDISTANCE, spaceFromBottom + 86); // Adjusted Y position for spread label
   ObjectSetInteger(0, spreadLabelName, OBJPROP_COLOR, spreadLabelColor);
   ObjectSetInteger(0, spreadLabelName, OBJPROP_FONTSIZE, labelFontSize);
   ObjectSetInteger(0, spreadLabelName, OBJPROP_SELECTABLE, false);
   ObjectSetInteger(0, spreadLabelName, OBJPROP_SELECTED, false);
   ObjectSetString(0, spreadLabelName, OBJPROP_TEXT, spreadText);
  }


//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
    createOrUpdateLabels(0.0, 0.0, 0, 0, 0.0);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
  double totalBuyProfit = 0.0;
   double totalSellProfit = 0.0;
   int buyCount = 0;
   int sellCount = 0;
   int vspread = (int)MarketInfo(_Symbol, MODE_SPREAD); // Using integer spread calculation

// Calculate total buy and sell profits and count trades
   for(int i = OrdersTotal() - 1; i >= 0; i--)
     {
      if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES) && OrderSymbol() == _Symbol)
        {
         if(OrderType() == OP_BUY)
           {
            totalBuyProfit += OrderProfit();
            buyCount++;  // Increment buy trade count
           }
         else if(OrderType() == OP_SELL)
           {
            totalSellProfit += OrderProfit();
            sellCount++;  // Increment sell trade count
           }
        }
     }

 createOrUpdateLabels(totalBuyProfit, totalSellProfit, buyCount, sellCount, vspread);
  }
//+------------------------------------------------------------------+
