//+------------------------------------------------------------------+
//|                                                 LS vs Robust.mq5 |
//|                                                      Aleksej1966 |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "Aleksej1966"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"

#define number 50
#include <Graphics\Graphic.mqh>
#include <Math\Stat\Normal.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   MathSrand(GetTickCount());

   double price[number],trend[number],ls[number],robust[number];
   double k=0.25,b=10;

   MathRandomNormal(0,1,number,price);

   for(int i=0; i<number; i++)
     {
      trend[i]=k*i+b;
      price[i]=price[i]+trend[i];
     }
//---
   double sumP=0,sumPI=0;
   for(int i=0; i<number; i++)
     {
      sumP=sumP+price[i];
      sumPI=sumPI+price[i]*i;
     }
   double k1=(12*sumPI+(6-6*number)*sumP)/(number*(number*number-1)),
          b1=((4*number-2)*sumP-6*sumPI)/(number*(number+1));
   for(int i=0; i<number; i++)
      ls[i]=k1*i+b1;
//---
   int size=number*(number-1)/2,cnt=0;
   double angle[],parameter[];
   ArrayResize(angle,size);
   ArrayResize(parameter,number);

   for(int i=number-2; i>=0; i--)
      for(int j=i+1; j<number; j++)
        {
         angle[cnt]=(price[j]-price[i])/(j-i);
         cnt++;
        }
   ArraySort(angle);
   int indx1=size/2,indx2=MathMod(size,2)==0? indx1-1:indx1;
   double k2=(angle[indx1]+angle[indx2])/2;

   for(int i=0; i<number; i++)
      parameter[i]=price[i]-k2*i;
   ArraySort(parameter);
   indx1=number/2;
   indx2=MathMod(number,2)==0? indx1-1:indx1;
   double b2=(parameter[indx1]+parameter[indx2])/2;

   for(int i=0; i<number; i++)
      robust[i]=k2*i+b2;
//---
   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic graphic;
   graphic.Create(0,"LS vs Robust",0,0,0,w,h);

   CCurve *curve1=graphic.CurveAdd(trend,CURVE_LINES);
   curve1.LinesWidth(2);
   curve1.Name("Trend");

   CCurve *curve2=graphic.CurveAdd(price,CURVE_LINES);
   curve2.LinesWidth(2);
   curve2.Name("Price");

   CCurve *curve3=graphic.CurveAdd(ls,CURVE_LINES);
   curve3.LinesWidth(2);
   curve3.Name("LS");

   CCurve *curve4=graphic.CurveAdd(robust,CURVE_LINES);
   curve4.LinesWidth(2);
   curve4.Name("Robust");

   graphic.CurvePlotAll();
   graphic.Update();

   ChartScreenShot(0,"LS vs Robust.png",w,h);

   Sleep(5000);
   graphic.Destroy();
   ChartSetInteger(0,CHART_SHOW,true);

   Print("Trend k = ",k," b = ",b);
   Print("LS k = ",k1," b = ",b1," error k = ",MathAbs(k1-k)," error b = ",MathAbs(b1-b));
   Print("Robust k = ",k2," b = ",b2," error k = ",MathAbs(k2-k)," error b = ",MathAbs(b2-b));
//---
  }
//+------------------------------------------------------------------+
