//+------------------------------------------------------------------+
//|                                              Angle Two Pairs.mq5 |
//|                                                      Aleksej1966 |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "Aleksej1966"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Angle"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input string SecSymbol="USDJPY";
input ushort iPeriod=15;

ushort period=2;
double buffer[],point,k;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);
   point=SymbolInfoDouble(SecSymbol,SYMBOL_POINT);
   k=2/MathSqrt(3)-1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

      for(int i=bars; i>=0; i--)
        {
         double sumC=0,sumS=0,angle=0;

         for(int j=0; j<period; j++)
           {
            int p=i+j;
            double x=open[p]/_Point,
                   y=iOpen(SecSymbol,PERIOD_CURRENT,p)/point,
                   r=MathSqrt(x*x+y*y);
            sumC=sumC+x/r;
            sumS=sumS+y/r;

            if(j==0)
               angle=MathArccos(x/r);
           }

         sumC=sumC/period;
         sumS=sumS/period;

         double mean=MathArctan(sumS/sumC),
                e=MathSqrt(1-sumC*sumC-sumS*sumS),
                sigma=MathArcsin(e)*(1+k*MathPow(e,3));

         buffer[i]=(angle-mean)/sigma;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
