//+------------------------------------------------------------------+
//|                                                    Angle CCI.mq5 |
//|                                                      Aleksej1966 |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "Aleksej1966"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Angle CCI"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=15;
int indx1,indx2,ind1,ind2;
double buffer[],data[],angle[],deviation[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   int size=iPeriod*(iPeriod-1)/2;
   ArrayResize(angle,size);
   ArrayResize(data,iPeriod);
   ArrayInitialize(data,1);
   ArrayResize(deviation,iPeriod);

   indx1=size/2;
   indx2=MathMod(size,2)==0? indx1-1:indx1;

   ind1=iPeriod/2;
   ind2=MathMod(iPeriod,2)==0? ind1-1:ind1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-iPeriod-1;

      for(int i=bars; i>=0; i--)
        {
         int cnt=0;
         for(int j=iPeriod-1; j>0; j--)
           {
            data[j]=data[j-1];
            for(int k=j-1; k>=0; k--)
              {
               angle[cnt]=(open[i+j]-open[i+k])/(j-k);
               cnt++;
              }
           }

         ArraySort(angle);
         data[0]=(angle[indx1]+angle[indx2])/2;

         ArrayCopy(deviation,data);
         ArraySort(deviation);
         double mean=(deviation[ind1]+deviation[ind2])/2;

         for(int j=0; j<iPeriod; j++)
            deviation[j]=MathAbs(deviation[j]-mean);

         ArraySort(deviation);
         double stdev=(deviation[ind1]+deviation[ind2])/2;

         buffer[i]=(data[0]-mean)/stdev;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
